/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.theme;

import com.aptana.core.logging.IdeLog;
import com.aptana.theme.ColorManager;
import com.aptana.theme.Theme;
import com.aptana.theme.ThemePlugin;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.console.TextConsole;

public class ConsoleThemer {
    public static final String CONSOLE_ERROR = "console.error";
    public static final String CONSOLE_OUTPUT = "console.output";
    public static final String CONSOLE_INPUT = "console.input";
    public static final String CONSOLE_PROMPT = "console.prompt";
    public static final String CONSOLE_WARNING = "console.warning";
    public static final String CONSOLE_TRACE = "console.prompt";
    public static final String CONSOLE_INFO = "console.input";
    private IEclipsePreferences.IPreferenceChangeListener fThemeChangeListener;
    private TextConsole fConsole;
    private Map fThemeConsoleStreamToColor;

    public ConsoleThemer(TextConsole textConsole, Map themeConsoleStreamToColor) {
        this.fConsole = textConsole;
        this.fThemeConsoleStreamToColor = themeConsoleStreamToColor;
        this.listenForThemeChanges();
        this.applyTheme();
    }

    private void applyTheme() {
        IWorkbench workbench = null;
        try {
            workbench = PlatformUI.getWorkbench();
        }
        catch (IllegalStateException e) {
            IdeLog.logError((Plugin)ThemePlugin.getDefault(), (Throwable)e);
        }
        if (workbench != null) {
            final Display display = workbench.getDisplay();
            display.syncExec(new Runnable(){

                public void run() {
                    ThemePlugin plugin = ThemePlugin.getDefault();
                    ColorManager colorManager = plugin.getColorManager();
                    Theme theme = plugin.getThemeManager().getCurrentTheme();
                    ConsoleThemer.this.fConsole.setBackground(null);
                    ConsoleThemer.this.fConsole.setBackground(colorManager.getColor(theme.getBackground()));
                    HashMap<String, Color> colorNameToDefault = new HashMap<String, Color>();
                    Color blue = display.getSystemColor(10);
                    Color green = display.getSystemColor(6);
                    Color yellow = display.getSystemColor(8);
                    Color red = display.getSystemColor(4);
                    colorNameToDefault.put(ConsoleThemer.CONSOLE_ERROR, red);
                    colorNameToDefault.put("console.input", green);
                    colorNameToDefault.put("console.input", green);
                    colorNameToDefault.put(ConsoleThemer.CONSOLE_OUTPUT, colorManager.getColor(theme.getForeground()));
                    colorNameToDefault.put("console.prompt", blue);
                    colorNameToDefault.put("console.prompt", blue);
                    colorNameToDefault.put(ConsoleThemer.CONSOLE_WARNING, yellow);
                    Set entrySet = ConsoleThemer.this.fThemeConsoleStreamToColor.entrySet();
                    for (Map.Entry entry : entrySet) {
                        if (!(entry.getValue() instanceof String) || !(entry.getKey() instanceof IOConsoleOutputStream)) continue;
                        String colorName = (String)entry.getValue();
                        IOConsoleOutputStream stream = (IOConsoleOutputStream)entry.getKey();
                        ConsoleThemer.this.applyTheme(colorName, stream, (Color)colorNameToDefault.get(colorName));
                    }
                    ConsoleThemer.this.refresh();
                }
            });
        }
    }

    public void refresh() {
        ConsolePlugin.getDefault().getConsoleManager().refresh((IConsole)this.fConsole);
    }

    private void applyTheme(String name, IOConsoleOutputStream stream, Color defaultColor) {
        Theme theme = ThemePlugin.getDefault().getThemeManager().getCurrentTheme();
        Color color = defaultColor;
        int style = 0;
        if (theme.hasEntry(name)) {
            TextAttribute attr = theme.getTextAttribute(name);
            color = theme.getForeground(name);
            style = attr.getStyle();
        }
        stream.setColor(color);
        stream.setFontStyle(style);
    }

    private void listenForThemeChanges() {
        this.fThemeChangeListener = new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                if (event.getKey().equals("THEME_CHANGED")) {
                    ConsoleThemer.this.applyTheme();
                }
            }
        };
        InstanceScope.INSTANCE.getNode("com.aptana.theme").addPreferenceChangeListener(this.fThemeChangeListener);
    }

    public void dispose() {
        InstanceScope.INSTANCE.getNode("com.aptana.theme").removePreferenceChangeListener(this.fThemeChangeListener);
        this.fConsole = null;
        this.fThemeConsoleStreamToColor = null;
    }
}

